libname q 'c:\SASCodeForBook\SASDataSets';

data first; set q.harfordschools;
if Scnum = 11 then delete;

                 /*These are the design variables*/

*cnvsmach =  conect = 1, matched no conect = 0 , not matched no conect = missing dot;

group3 = . ;
if cnvsmach = 1 then group3= 1;
if cnvsmach = 0 then group3= 3;
if cnvsmach = . then group3= 2;

* Note:  the above code refers all comparisons to the matched group!;

group2 = .;
if cnvsmach = 1 then group2= 1;
Else group2 = 0;
* Note:  the above code refers all comparisons to the non co-nect groups;

                /*This code creates the year dummy variables */

year97 = . ;
if testyear = 1997 then year97 = 1;
else year97=0;

year98 = . ;
if testyear = 1998 then year98 = 1;
else year98=0;

year99 = . ;
if testyear = 1999 then year99 = 1;
else year99 = 0;

year20 = .;
if testyear = 2000 then year20 = 1;
else year20 = 0;

year21 = .;
if testyear = 2001 then year21 = 1;
else year21 = 0;

year22 = .;
if testyear = 2002 then year22 = 1;
else year22 = 0;



*This code groups all non conect together and creates indicator variable;

cnvsall = . ;
if cnvsmach = . or cnvsmach = 0 then cnvsall = 0;
if cnvsmach = 1 then cnvsall = 1;

* This code breaks up the groups for detailed assessment;
conect=. ;
if group3 = 1 then conect=1;
else conect = 0;

nomatch =. ;
if group3 = 2 then nomatch = 1;
else nomatch = 0;

match =.;
if group3 = 3 then match = 1;
else match = 0;

conect98 = conect*year98;
conect99 = conect*year99;
conect20 = conect*year20;
conect21 = conect*year21;
conect22 = conect*year22;

nomat98 = nomatch*year98;
nomat99 = nomatch*year99;
nomat20 = nomatch*year20;
nomat21 = nomatch*year21;
nomat22 = nomatch*year22;

ryear20 = .;
if year20 = 1 then ryear20 = 0; *post time period;
if year20 = 0 then ryear20 = 1; *base periods;

                                 /*These variables are properties of the school*/

*This code creates dummy variables for lowest grade of school, KG is one preKG is zero;

If substr (Low_Grade,1,12)=  'Kindergarten' then lowstgrd = 1;
If substr (Low_Grade,1,15)=  'Prekindergarten' then lowstgrd = 0;

*This code creates dummy variable for location, urban fringe is one rural is zero;
locate = .;

If substr (locale,1,26) = 'Urban Fringe of Large City' then locate =1;
else locate = 0;

*This code creates dummy variable for targeted title1 school, one is yes it is,zero is no;
*No Conect schools are Title1 schools;

TargetT1 = . ;
if substr (title1sc,1,2) = 'No' then TargetT1 = 0;
if substr (title1sc,1,3) = 'Yes' then TargetT1 = 1;


*This code creates targeted poverty under SAFE;
Safe = . ;
if scnum = 2 or scnum = 4 or scnum = 6 or scnum = 7 or scnum = 8 or scnum = 20
or scnum = 29 then safe = 1; Else safe = 0;

lowecon = . ;
if safe = 1 and targett1 = 1 then lowecon = 2;
else if safe = 0 and targett1 = 0 then lowecon = 0;
else lowecon = 1;



     /*These Codes refer to the composition of the school*/

*This creates a gender variable, female to male ratio;
Femvmal = female/male;
femprob = female/studentt;

*These codes create proportions for ethnicity;
Nativep = Native_A/studentt;
Asianp  = Asian/studentt;
Blackp  = Black/studentt;
Hispanp = Hispanic/studentt;
Whitep  = White/studentt;


                /*this code creates a simple weight by implementation variable*/

impscore = 1 ;
if scnum= 6 then do;
        impscore = 1.52;
        end;
if scnum = 7 then do;
        impscore = 1.56;
                end;
if scnum = 17 then do;
        impscore = 1.8;
        end;
if scnum = 25 then do;
        impscore = 1.79;
        end;
if scnum = 31 then do;
        impscore = 1.86;
        end;
run;


data second; set first;
if year97=1 or year98=1 or year99=1 or year20=1;

	/*This code changes the names of some variables and restricts the data set*/
Trt = Group3;
Post = 	ryear20;
run;
								

        /* This code standardizes the variables by their means*/
proc standard data = second out= standard mean=0; weight impscore;
var lowstgrd locate targett1 stratio femprob blackp forredlp safe year98 year99 ;

proc means data= standard; var lowstgrd locate targett1 stratio femprob blackp forredlp safe
        year98 year99 year20 msapperform avecomp gr3comp gr3read gr3math
        gr5comp gr5read gr5math ; weight impscore;

/*When ryear20 = zero it indicates year 2000, when it is one it indicates 1997*/

Title 'Covariance Tests in Proc Glimmix MSAP Performance Data Used in Box 11.6 and Table 11.5';
proc GLIMMIX data=standard ic= Q ;
	class  school Trt Post ;
	model msapperform = Trt Post Trt*Post year98 year99 lowstgrd locate targett1 safe
	stratio femprob Blackp forredlp / solution dist=normal link =identity;
	random _residual_ /type = unr sub = school(trt)  s v vcorr;
	weight impscore;
covtest 'Ho:No G-Side Random Effects (UNR Parameters) ' ZeroG /cl ;
covtest 'H0:Diagonal R-side VC or UN(1)' Indep /cl ;  
covtest 'Ho:Heterogeneous CS' General
	0 0 0 0 1 -1,
	0 0 0 0 1  0 -1,
	0 0 0 0 1  0 0 -1,
    0 0 0 0 1  0 0 0 -1,
	0 0 0 0 1  0 0 0 0 -1 / estimates;
covtest 'CS' General
	1 -1,
	1 0 -1,
	1 0  0 -1,
	0 0  0  0 1 -1,
	0 0  0  0 1  0 -1,
	0 0  0  0 1  0  0 -1,
    0 0  0  0 1  0  0  0 -1,
	0 0  0  0 1  0  0  0  0 -1 / estimates;
run;


Title 'Covariance Tests in Proc Glimmix, grade3 reading Performance Used in Table 11.5 and Text';
	proc GLIMMIX data=standard ic= Q ;
	class  school Trt Post ;
	model gr3read = Trt Post Trt*Post year98 year99 lowstgrd locate targett1 safe
	stratio femprob Blackp forredlp / solution dist=normal link =identity;
	random _residual_ /type = unr sub = school(trt)  s v vcorr;
	weight impscore;
covtest 'Ho:No G-Side Random Effects (UNR Parameters)      '	ZeroG /cl ;
covtest 'H0:Diagonal R-side VC or UN(1)' Indep /cl ;  
covtest 'Ho:Heterogeneous CS' General
	0 0 0 0 1 -1,
	0 0 0 0 1 0 -1,
	0 0 0 0 1 0 0 -1,
    0 0 0 0 1 0 0 0 -1,
	0 0 0 0 1 0 0 0 0 -1 / estimates;
covtest 'CS' General
	1 -1,
	1 0 -1,
	1 0 0 -1,
	0 0 0 0 1 -1,
	0 0 0 0 1 0 -1,
	0 0 0 0 1 0 0 -1,
    0 0 0 0 1 0 0 0 -1,
	0 0 0 0 1 0 0 0 0 -1 / estimates;
run;



Title'Covariance Tests in Proc Glimmix,grade5 reading Performance,used in text and Table 11.5';
proc GLIMMIX data=standard ic= Q ;
	class  school Trt Post ;
	model gr5read = Trt Post Trt*Post year98 year99 lowstgrd locate targett1 safe
	stratio femprob Blackp forredlp / solution dist=normal link =identity;
	random _residual_ /type = unr sub = school(trt)  s v vcorr;
	weight impscore;
covtest 'Ho:No G-Side Random Effects (UNR Parameters)  ' ZeroG /cl ;
covtest 'H0:Diagonal R-side VC or UN(1)' Indep /cl ;  
covtest 'Ho:Heterogeneous CS' General
	0 0 0 0 1 -1,
	0 0 0 0 1 0 -1,
	0 0 0 0 1 0 0 -1,
    0 0 0 0 1 0 0 0 -1,
	0 0 0 0 1 0 0 0 0 -1 / estimates;
covtest 'CS' General
	1 -1,
	1 0 -1,
	1 0 0 -1,
	0 0 0 0 1 -1,
	0 0 0 0 1 0 -1,
	0 0 0 0 1 0 0 -1,
    0 0 0 0 1 0 0 0 -1,
	0 0 0 0 1 0 0 0 0 -1 / estimates;
run;

						/*  Additional Covariance Structures for Table 11.5 */

Title 'Covariance Tests in Proc Glimmix, Average Composite in Table 11.5';
proc GLIMMIX data=standard ic= Q ;
	class  school Trt Post ;
	model AveComp = Trt Post Trt*Post year98 year99 lowstgrd locate targett1 safe
	stratio femprob Blackp forredlp / solution dist=normal link =identity;
	random _residual_ /type = unr sub = school(trt)  s v vcorr;
	weight impscore;
covtest 'Ho:No G-Side Random Effects (UNR Parameters)  '	ZeroG /cl ;
covtest 'H0:Diagonal R-side VC or UN(1)' Indep /cl ;  
covtest 'Ho:Heterogeneous CS' General
	0 0 0 0 1 -1,
	0 0 0 0 1 0 -1,
	0 0 0 0 1 0 0 -1,
    0 0 0 0 1 0 0 0 -1,
	0 0 0 0 1 0 0 0 0 -1 / estimates;
covtest 'CS' General
	1 -1,
	1 0 -1,
	1 0 0 -1,
	0 0 0 0 1 -1,
	0 0 0 0 1 0 -1,
	0 0 0 0 1 0 0 -1,
    0 0 0 0 1 0 0 0 -1,
	0 0 0 0 1 0 0 0 0 -1 / estimates;
run;



Title 'Covariance Tests in Proc Glimmix, Grade Three Composite in Table 11.5';
proc GLIMMIX data=standard ic= Q ;
	class  school Trt Post ;
	model GR3Comp = Trt Post Trt*Post year98 year99 lowstgrd locate targett1 safe
	stratio femprob Blackp forredlp / solution dist=normal link =identity;
	random _residual_ /type = unr sub = school(trt)  s v vcorr;
	weight impscore;
covtest 'Ho:No G-Side Random Effects (UNR Parameters)  '	ZeroG /cl ;
covtest 'H0:Diagonal R-side VC or UN(1)' Indep /cl ;  
covtest 'Ho:Heterogeneous CS' General
	0 0 0 0 1 -1,
	0 0 0 0 1 0 -1,
	0 0 0 0 1 0 0 -1,
    0 0 0 0 1 0 0 0 -1,
	0 0 0 0 1 0 0 0 0 -1 / estimates;
covtest 'CS' General
	1 -1,
	1 0 -1,
	1 0 0 -1,
	0 0 0 0 1 -1,
	0 0 0 0 1 0 -1,
	0 0 0 0 1 0 0 -1,
    0 0 0 0 1 0 0 0 -1,
	0 0 0 0 1 0 0 0 0 -1 / estimates;
run;


Title 'Covariance Tests in Proc Glimmix, Grade Three Mathematics in Table 11.5';
proc GLIMMIX data=standard ic= Q ;
	class  school Trt Post ;
	model GR3Math = Trt Post Trt*Post year98 year99 lowstgrd locate targett1 safe
	stratio femprob Blackp forredlp / solution dist=normal link =identity;
	random _residual_ /type = unr sub = school(trt)  s v vcorr;
	weight impscore;
covtest 'Ho:No G-Side Random Effects (UNR Parameters)  '	ZeroG /cl ;
covtest 'H0:Diagonal R-side VC or UN(1)' Indep /cl ;  
covtest 'Ho:Heterogeneous CS' General
	0 0 0 0 1 -1,
	0 0 0 0 1 0 -1,
	0 0 0 0 1 0 0 -1,
    0 0 0 0 1 0 0 0 -1,
	0 0 0 0 1 0 0 0 0 -1 / estimates;
covtest 'CS' General
	1 -1,
	1 0 -1,
	1 0 0 -1,
	0 0 0 0 1 -1,
	0 0 0 0 1 0 -1,
	0 0 0 0 1 0 0 -1,
    0 0 0 0 1 0 0 0 -1,
	0 0 0 0 1 0 0 0 0 -1 / estimates;
run;


Title 'Covariance Tests in Proc Glimmix, Grade Five Composite in Table 11.5';
proc GLIMMIX data=standard ic= Q ;
	class  school Trt Post ;
	model GR5Comp = Trt Post Trt*Post year98 year99 lowstgrd locate targett1 safe
	stratio femprob Blackp forredlp / solution dist=normal link =identity;
	random _residual_ /type = unr sub = school(trt)  s v vcorr;
	weight impscore;
covtest 'Ho:No G-Side Random Effects (UNR Parameters)  '	ZeroG /cl ;
covtest 'H0:Diagonal R-side VC or UN(1)' Indep /cl ;  
covtest 'Ho:Heterogeneous CS' General
	0 0 0 0 1 -1,
	0 0 0 0 1 0 -1,
	0 0 0 0 1 0 0 -1,
    0 0 0 0 1 0 0 0 -1,
	0 0 0 0 1 0 0 0 0 -1 / estimates;
covtest 'CS' General
	1 -1,
	1 0 -1,
	1 0 0 -1,
	0 0 0 0 1 -1,
	0 0 0 0 1 0 -1,
	0 0 0 0 1 0 0 -1,
    0 0 0 0 1 0 0 0 -1,
	0 0 0 0 1 0 0 0 0 -1 / estimates;
run;

		/*This model does not estimate properly*/

Title 'Covariance Tests in Proc Glimmix, Grade Five Mathematics in Table 11.5';
proc GLIMMIX data=standard ic= Q ;
	class  school Trt Post ;
	model GR5Math = Trt Post Trt*Post year98 year99 lowstgrd locate targett1 safe
	stratio femprob Blackp forredlp / solution dist=normal link =identity;
	random _residual_ /type = unr sub = school(trt)  s v vcorr;
	weight impscore;
covtest 'Ho:No G-Side Random Effects (UNR Parameters)  '	ZeroG /cl ;
covtest 'H0:Diagonal R-side VC or UN(1)' Indep /cl ;  
covtest 'Ho:Heterogeneous CS' General
	0 0 0 0 1 -1,
	0 0 0 0 1 0 -1,
	0 0 0 0 1 0 0 -1,
    0 0 0 0 1 0 0 0 -1,
	0 0 0 0 1 0 0 0 0 -1 / estimates;
covtest 'CS' General
	1 -1,
	1 0 -1,
	1 0 0 -1,
	0 0 0 0 1 -1,
	0 0 0 0 1 0 -1,
	0 0 0 0 1 0 0 -1,
    0 0 0 0 1 0 0 0 -1,
	0 0 0 0 1 0 0 0 0 -1 / estimates;
run;


Title 'Covariance Tests in Proc Glimmix, Grade Five Mathematics in Table 11.5  VC Model';
proc mixed data=standard ;
	class  school Trt Post ;
	model GR5Math = Trt Post Trt*Post year98 year99 lowstgrd locate targett1 safe
	stratio femprob Blackp forredlp / solution ;
	repeated /type = VC sub = school(trt);
	weight impscore;
run;


Title 'Covariance Tests in Proc Glimmix, Grade Five Mathematics in Table 11.5  UN(1) Model';
proc mixed data=standard ;
	class  school Trt Post ;
	model GR5Math = Trt Post Trt*Post year98 year99 lowstgrd locate targett1 safe
	stratio femprob Blackp forredlp / solution ;
	repeated /type = un(1) sub = school(trt);
	weight impscore;
run;

Title 'Covariance Tests in Proc Glimmix, Grade Five Mathematics in Table 11.5  CSH Model';
proc mixed data=standard ;
	class  school Trt Post ;
	model GR5Math = Trt Post Trt*Post year98 year99 lowstgrd locate targett1 safe
	stratio femprob Blackp forredlp / solution ;
	repeated /type = CSH sub = school(trt);
	weight impscore;
run;

Title 'Covariance Tests in Proc Glimmix, Grade Five Mathematics in Table 11.5  CS Model';
proc mixed data=standard ;
	class  school Trt Post ;
	model GR5Math = Trt Post Trt*Post year98 year99 lowstgrd locate targett1 safe
	stratio femprob Blackp forredlp / solution ;
	repeated /type = CS sub = school(trt);
	weight impscore;
run;

/* The syntax for Table 11.5 is now complete*/
/* The syntax in this file is copyright by Robert B. Smith,  2011*/
